% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{td_orderDetail}
\alias{td_orderDetail}
\title{Get Details for a Single Order}
\usage{
td_orderDetail(orderId, accountNumber, accessToken = NULL)
}
\arguments{
\item{orderId}{A valid TD Ameritrade Order ID}

\item{accountNumber}{The TD brokerage account number associated with the
Access Token}

\item{accessToken}{A valid Access Token must be set using
\code{\link{td_auth_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
list of order details
}
\description{
Pass an order ID and Account number to get details such as status, quantity,
ticker, executions (if applicable), account, etc.
}
\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# generate a new access token
accessToken = td_auth_accessToken(refreshToken, 'consumerKey')

# Get order details for a single order
# Passing Access Token is optional once it's been set
td_orderDetail(orderId = 123456789, accountNumber = 987654321)

}
}
