% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_records.R
\name{delete_records}
\alias{delete_records}
\title{Delete airtable records}
\usage{
delete_records(
  data,
  airtable,
  airtable_id_col = NULL,
  safely = TRUE,
  batch_size = 10
)
}
\arguments{
\item{data}{A data frame containing records to delete}

\item{airtable}{An airtable object}

\item{airtable_id_col}{Column containing Airtable record IDs. Not required if record IDs are stored in row names as returned from \code{read_airtable}.}

\item{safely}{If \code{TRUE}, ask for confirmation before executing DELETE request}

\item{batch_size}{Number of requests to send at a time. Maximum of 10.}
}
\value{
A vector of IDs deleted
}
\description{
Delete records in an Airtable table based on their Airtable record ID.
}
