% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyness.R
\name{rainette_stats}
\alias{rainette_stats}
\title{Generate cluster keyness statistics from a rainette result}
\usage{
rainette_stats(
  groups,
  dtm,
  measure = c("chi2", "lr"),
  n_terms = 15,
  show_negative = TRUE,
  max_p = 0.05
)
}
\arguments{
\item{groups}{groups membership computed by \code{cutree_rainette} or \code{cutree_rainette2}}

\item{dtm}{the dfm object used to compute the clustering}

\item{measure}{statistics to compute}

\item{n_terms}{number of terms to display in keyness plots}

\item{show_negative}{if TRUE, show negative keyness features}

\item{max_p}{maximum keyness statistic p-value}
}
\value{
A list with, for each group, a data.frame of keyness statistics for the most specific
n_terms features.
}
\description{
Generate cluster keyness statistics from a rainette result
}
\examples{
\donttest{
library(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
dtm <- dfm(corpus, remove = stopwords("en"), tolower = TRUE, remove_punct = TRUE)
dtm <- dfm_trim(dtm, min_termfreq = 3)
res <- rainette(dtm, k = 3)
groups <- cutree_rainette(res, k = 3)
rainette_stats(groups, dtm)
}
}
\seealso{
\code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}, \code{\link[=rainette_explor]{rainette_explor()}}, \code{\link[=rainette_plot]{rainette_plot()}}
}
