% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{form_present_value_grid}
\alias{form_present_value_grid}
\title{Use a model to estimate the present value of financial derivatives on a grid of initial underlying values}
\usage{
form_present_value_grid(S0, num_time_steps, instruments,
  const_volatility = 0.5, const_short_rate = 0,
  const_default_intensity = 0, override_Tmax = NA,
  discount_factor_fcn = function(T, t, ...) {     exp(-const_short_rate * (T -
  t)) }, default_intensity_fcn = function(t, S, ...) {    
  const_default_intensity + 0 * S }, variance_cumulation_fcn = function(T, t)
  {     const_volatility^2 * (T - t) }, dividends = NULL, borrow_cost = 0,
  dividend_rate = 0, structure_constant = 2, std_devs_width = 3,
  grid_center = NA)
}
\arguments{
\item{S0}{An initial stock price, for setting grid scale}

\item{num_time_steps}{Minimum number of time steps in the grid}

\item{instruments}{A list of instruments to be priced.  Each
one must have a \code{strike} and a \code{optionality_fcn}, as
with \code{\link{GridPricedInstrument}} and its subclasses.}

\item{const_volatility}{A constant to use for volatility in case \code{variance_cumulation_fcn}
is not given}

\item{const_short_rate}{A constant to use for the instantaneous interest rate in case \code{discount_factor_fcn}
is not given}

\item{const_default_intensity}{A constant to use for the instantaneous default intensity in case \code{default_intensity_fcn}
is not given}

\item{override_Tmax}{A different maximum time on the grid to enforce}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{default_intensity_fcn}{A function for computing default intensity
occurring during this timestep, dependent on time and stock price, with
arguments \code{t}, \code{S}.}

\item{variance_cumulation_fcn}{A function for computing total stock variance
occurring during this timestep, with arguments \code{T}, \code{t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}}

\item{borrow_cost}{Stock borrow cost, affecting the drift rate}

\item{dividend_rate}{Continuous dividend rate, affecting the drift rate}

\item{structure_constant}{The maximum ratio between time intervals \code{dt}
and the square of space intervals \code{dz^2}}

\item{std_devs_width}{The number of standard deviations, in \code{sigma * sqrt(T)}
units, to incorporate into the grid}

\item{grid_center}{A reasonable central value for the grid, defaults to S0 or an instrument strike}
}
\description{
Use a finite difference scheme to form estimates of present values for a variety
 of stock prices on a grid of initial underlying prices, determined by constructing
 a logarithmic equivalent conforming to the grid parameters \code{structure_constant}
 and \code{structure_constant}
}
\details{
If any instrument in the \code{instruments} has a strike, then the grid will be
 normalized to the last such instrument's strike.
}
\seealso{
Other Equity Dependent Default Intensity: \code{\link{find_present_value}},
  \code{\link{fit_to_option_market_df}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{implied_jump_process_volatility}}

Other Implicit Grid Solver: \code{\link{construct_implicit_grid_structure}},
  \code{\link{find_present_value}},
  \code{\link{infer_conforming_time_grid}},
  \code{\link{integrate_pde}},
  \code{\link{iterate_grid_from_timestep}},
  \code{\link{take_implicit_timestep}},
  \code{\link{timestep_instruments}}
}

