% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si.sp.R
\name{si.sp}
\alias{si.sp}
\title{source emission data - other than beta for MCNP  '}
\usage{
si.sp(desired_RN, rad_code, E_min = 0, erg_dist = 1)
}
\arguments{
\item{desired_RN}{The radionuclide of interest in format element-isotope,
followed by m if metastable. Must be in quotes, e.g. "Ba-137m"}

\item{rad_code}{Enter "P" for all photons. Other options are: "G" = Gamma
"PG" = Prompt Gamma "DG" = Delayed Gamma "X" = X-Ray "B+" = Beta Positive
"AQ" = Annihilation Quanta "B-" = Beta Negative (Only includes average
energy use beta.si.sp for beta distribution) "DB" = Delayed Beta "IE" =
Internal Conversion Electron "AE" = Auger Electron "A" = Alpha "AR" = Alpha
Recoil "FF" = Fission Fragment "N" = Neutron}

\item{E_min}{Energy cutoff, default = 0. Provided because running very low
energy photons may be costly in run time without any addition to dose rate
in a shielding calculation, for example.}

\item{erg_dist}{Energy distribution number. Defaults to 1. Helpful if several
isotopes are used in a single MCNP input.}
}
\value{
A text file, si.sp.dat, is written to the user's working file. It
  contains an energy distribution in a format compliant with MCNP. New data
  is appended to any exising data in the file if it already exists.
}
\description{
Make energy distribution for MCNP input '
}
\examples{
si.sp("Pu-238", rad_code = "P", E_min = 0, erg_dist = 11)
si.sp("Am-241", rad_code = "A", E_min = 0, erg_dist = 23)
}
