% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{mnl}
\alias{mnl}
\title{Multinomial logistic regression}
\usage{
mnl(
  dataset,
  rvar,
  evar,
  lev = "",
  int = "",
  wts = "None",
  check = "",
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{lev}{The level in the response variable to use as the baseline}

\item{int}{Interaction term to include in the model}

\item{wts}{Weights to use in estimation}

\item{check}{Use "standardize" to see standardized coefficient estimates. Use "stepwise-backward" (or "stepwise-forward", or "stepwise-both") to apply step-wise selection of variables in estimation.}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in mnl as an object of class mnl
}
\description{
Multinomial logistic regression
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/mnl.html} for an example in Radiant
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
str(result)

}
\seealso{
\code{\link{summary.mnl}} to summarize the results

\code{\link{plot.mnl}} to plot the results

\code{\link{predict.mnl}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
