% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{plot.logistic}
\alias{plot.logistic}
\title{Plot method for the logistic function}
\usage{
\method{plot}{logistic}(
  x,
  plots = "coef",
  conf_lev = 0.95,
  intercept = FALSE,
  incl = NULL,
  excl = NULL,
  nrobs = -1,
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{x}{Return value from \code{\link{logistic}}}

\item{plots}{Plots to produce for the specified GLM model. Use "" to avoid showing any plots (default). "dist" shows histograms (or frequency bar plots) of all variables in the model. "scatter" shows scatter plots (or box plots for factors) for the response variable with each explanatory variable. "coef" provides a coefficient plot and "influence" shows (potentially) influential observations}

\item{conf_lev}{Confidence level to use for coefficient and odds confidence intervals (.95 is the default)}

\item{intercept}{Include the intercept in the coefficient plot (TRUE or FALSE). FALSE is the default}

\item{incl}{Which variables to include in a coefficient plot}

\item{excl}{Which variables to exclude in a coefficient plot}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{https://ggplot2.tidyverse.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the logistic function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/logistic.html} for an example in Radiant
}
\examples{
result <- logistic(titanic, "survived", c("pclass", "sex"), lev = "Yes")
plot(result, plots = "coef")
}
\seealso{
\code{\link{logistic}} to generate results

\code{\link{plot.logistic}} to plot results

\code{\link{predict.logistic}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
