% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{store.model.predict}
\alias{store.model.predict}
\title{Store predicted values generated in model functions}
\usage{
\method{store}{model.predict}(dataset, object, name = "prediction", ...)
}
\arguments{
\item{dataset}{Dataset to add predictions to}

\item{object}{Return value from model function}

\item{name}{Variable name(s) assigned to predicted values}

\item{...}{Additional arguments}
}
\description{
Store predicted values generated in model functions
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
regress(diamonds, rvar = "price", evar = c("carat", "cut")) \%>\%
  predict(pred_data = diamonds) \%>\%
  store(diamonds, ., name = c("pred", "pred_low", "pred_high")) \%>\%
  head()

}
