% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{deletionsByBinom}
\alias{deletionsByBinom}
\title{Double chromosome deletion by relative gene usage}
\usage{
deletionsByBinom(clip_db, chain = c("IGH", "IGK", "IGL"),
  nonReliable_Vgenes = c())
}
\arguments{
\item{clip_db}{a \code{data.frame} in Change-O format. See details.}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH.}

\item{nonReliable_Vgenes}{a list of known non reliable gene assignments. A \code{list} created by \code{nonReliableVGenes}.}
}
\value{
A \code{data.frame}, in which each row is the double chomosome deletion inference of a gene.

The output containes the following columns:
\itemize{
 \item \code{SUBJECT}:       the subject name.
 \item \code{GENE}:          the gene call
 \item \code{FRAC}:          the relative gene usage of the gene
 \item \code{CUTOFF}:        the the cutoff of for the binomial test
 \item \code{PVAL}:          the p-value of the binomial test
 \item \code{DELETION}:      if a double chromosome deletion event of a gene occured.
}
}
\description{
The \code{deletionsByBinom} function inferes double chromosome deletion events by relative gene usage.
}
\details{
The function accepts a \code{data.frame} in Change-O format (\url{https://changeo.readthedocs.io/en/version-0.4.1---airr-standards/standard.html}) containing the following columns:
\itemize{
  \item \code{'SUBJECT'}: The subject name
  \item \code{'V_CALL'}: V allele call(s) (in an IMGT format)
  \item \code{'D_CALL'}: D allele call(s) (in an IMGT format, only for heavy chains)
  \item \code{'J_CALL'}: J allele call(s) (in an IMGT format)
}
}
\examples{
# Load example data and germlines
data(samples_db)

# Selecting a single individual
clip_db = samples_db[samples_db$SUBJECT=='I5', ]
# Infering haplotype
del_binom_df = deletionsByBinom(clip_db)
head(del_binom_df)

}
