% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getMeasurementData}
\alias{getMeasurementData}
\title{Get a table of trait measurements from YouTheria}
\usage{
getMeasurementData(measurementType = NA, MSW93Binomial = NA,
  MSW05Binomial = NA, country = NULL, StudyUnitId = NULL,
  locationData = TRUE, locationOnly = FALSE, cast = TRUE,
  silent = FALSE)
}
\arguments{
\item{measurementType}{Measurement types to collect data for. If \code{NULL} (default),
all measurement types are returned. Can also be 'numeric' or 'character' (or a
list of either type) and will filter by MeasurementTypeID and the measurement
respectivly. MeasurementTypeIDs and names can be found using getMeasurementTypes().}

\item{MSW93Binomial}{Character giving the latin name of a species (or list of species)
for which measurements are required. Naming should follow Mammal Species of the
World 1993.}

\item{MSW05Binomial}{Character giving the latin name of a species (or list of species)
for which measurements are required. Naming should follow Mammal Species of the
World 2005.}

\item{country}{Character specifying the country from which you wish to collect data.
If \code{NULL} all data is retrieved. If specified then \code{locationOnly}
is set to \code{TRUE}}

\item{StudyUnitId}{Numeric specifying the StudyUnitId from which you wish to collect data.
If \code{NULL} all data is retrieved}

\item{locationData}{Logial dictating whether location information should be added to the
output. Defualt is \code{FALSE} but is set to \code{TRUE} if either StudyUnitId or
country are specified.}

\item{locationOnly}{If \code{TRUE} data is only be returned if it has location information.}

\item{cast}{If \code{TRUE} (default) then the data is cast so that each observation
is one row in the output. If false then each observation has one row for
each data element recorded (i.e. range, mean, units, etc)}

\item{silent}{If \code{TRUE} progress reporting is silenced}
}
\value{
A \code{data.frame} with each row giving a trait measurement
}
\description{
Retrieves a \code{data.frame} of trait measurements with facilities to select by
location, species name and/or measurement type.
}
\examples{
\dontrun{
# Select measurement type by id
M14 <- getMeasurementData(14)
M22_7_2 <- getMeasurementData(c(22,7,2))

# Select measurement type by name
WM <- getMeasurementData('Wing Morphology')
WM_TN <- getMeasurementData(c('Wing Morphology','Teat Number'))

# Select by measurement type and species name
PpPr_bodymass <- getMeasurementData(measurementType = 1,
                                    MSW93Binomial = c('Pongo pygmaeus','Peroryctes raffrayana'))

#Select by measurement type, species name and location
Ob_Activity_Tanz <- getMeasurementData(measurementType = 'Activity Cycle',
                                       MSW05Binomial = 'Oryx beisa',
                                       country = 'Tanzania')
}
}

