% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{tidy}
\alias{tidy}
\alias{tidy.rWind_series}
\title{Transforming a rWind_series object into a data.frame}
\usage{
tidy(x, ...)

\method{tidy}{rWind_series}(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy data.frame}

\item{...}{extra arguments}
}
\description{
The output of tidy is always a data.frame. It is therefore suited for further
manipulation by packages like dplyr, reshape2, ggplot2 and ggvis.
}
\examples{
data(wind.series)
df <- tidy(wind.series)
head(df)
\dontrun{
# use the tidyverse
library(dplyr)
mean_speed <- tidy(wind.series) \%>\%
  group_by(lat, lon) \%>\%
  summarise(speed = mean(speed))
wind_average2 <- wind.mean(wind.series)
all.equal(wind_average2$speed, mean_speed$speed)
}
}
