% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_cylinders.R
\name{update_cylinders}
\alias{update_cylinders}
\title{Update Cylinders}
\usage{
update_cylinders(cylinder)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}
}
\value{
Returns a data frame
}
\description{
Updates the QSM cylinder data in preparation for radii correction
}
\details{
Updates parent-child branch and cylinder relationships to fill in any gaps.
Four useful QSM metrics developed by Jan Hackenberg are also calculated.
Growth length is the length of a parent cylinder, plus the lengths of all of
its child cylinders. The segment is a portion of a branch between two branching nodes.
The reverse branch order assigns twigs as order 1 and works backwards at each
branching junction to the base of the stem, which has the largest reverse branch order.
Distance from twig is the average distance to all connected twigs for a given cylinder.
Two new metrics, distance from base, and total children, are also calculated.
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
str(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
str(cylinder)

}
\references{
\insertRef{growth_parameter1}{rTwig}

\insertRef{growth_parameter2}{rTwig}
}
