% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mat.R
\name{export_mat}
\alias{export_mat}
\title{Export MAT}
\usage{
export_mat(cylinder, filename)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{filename}{Desired name of file}
}
\value{
Returns a .mat file
}
\description{
Exports the cylinder data to be visualized with TreeQSM's plot_cylinder_model() function
}
\examples{
\donttest{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "TreeQSM_QSM.mat")
export_mat(cylinder, filename)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "SimpleForest_QSM.mat")
export_mat(cylinder, filename)

}

}
