\name{as.tensor}
\alias{as.tensor}
\title{Tensor Conversion}
\usage{
  as.tensor(x, drop = FALSE)
}
\arguments{
  \item{x}{an instance of \code{array}, \code{matrix}, or
  \code{vector}}

  \item{drop}{whether or not modes of 1 should be dropped}
}
\value{
  a \code{\link{Tensor-class}} object
}
\description{
  Create a \code{\link{Tensor-class}} object from an
  \code{array}, \code{matrix}, or \code{vector}.
}
\examples{
#From vector
vec <- runif(100); vecT <- as.tensor(vec); vecT
#From matrix
mat <- matrix(runif(1000),nrow=100,ncol=10)
matT <- as.tensor(mat); matT
#From array
indices <- c(10,20,30,40)
arr <- array(runif(prod(indices)), dim = indices)
arrT <- as.tensor(arr); arrT
}

