% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radius_search.R
\name{radius_search}
\alias{radius_search}
\title{Radius Search of Points}
\usage{
radius_search(
  query,
  ref,
  radius,
  max_neighbour,
  distance = "euclidean",
  same = FALSE,
  threads = 1L,
  verbose = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{query}{A \code{data.table} containing the set of query points where each row represent a point and each column a given coordinate.}

\item{ref}{A \code{numeric} containing the set of reference points where each row represent a point and each column a given coordinate.}

\item{radius}{A \code{numeric} describing maximum euclidean distance form the each query points in which a point can be consider a neighbor.}

\item{max_neighbour}{An \code{integer} specifying the maximum number of ref points to look around to consider for a given radius.}

\item{distance}{Type of distance to calculate. \code{"euclidean"} as default. Look \code{hnsw_knn} for more options.}

\item{same}{Logic. If \code{TRUE}, it delete neighbors with distance of 0, useful when the k search is based on the same query.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}

\item{verbose}{If TRUE, log messages to the console.}

\item{progress}{If TRUE, log a progress bar when \code{verbose = TRUE}. Tracking progress could cause a small overhead.}

\item{...}{Arguments passed to \code{hnsw_build} and \code{hnsw_search}.}
}
\value{
A \code{data.table} with three columns describing the indices of the query and ref points and the distances.
}
\description{
Adapted radius searching of points based on RcppHNSW
}
\details{
This function is based on hnswlib C++ library (Malkov & Yashunin 2016) and
its bindings for R (RcppHNSW; Melville 2020) for a fast estimation of neighbors
points. It is adapted to simplify the workflow within rTLS.
If you use this function, please consider cite the C++ library and
\code{RcppHNSW} package.
}
\examples{

#Point cloud
data("pc_tree")

\donttest{
#Radius search of 1
radius_search(pc_tree, pc_tree, radius = 1, max_neighbour = 100)
}

}
\references{
Malkov, Y. A., & Yashunin, D. A. (2016). Efficient and robust approximate nearest neighbor search using Hierarchical Navigable Small World graphs. arXiv preprint arXiv:1603.09320.
}
\seealso{
\code{\link{radius_search}}
}
\author{
J. Antonio Guzmán Q.
}
