% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_seg_efforts.R
\name{compile_seg_efforts}
\alias{compile_seg_efforts}
\title{Compile the efforts of multiple segments}
\usage{
compile_seg_efforts(segment_ids, stoken)
}
\arguments{
\item{segment_ids}{A vector of segment ids from which to compile efforts}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}
}
\value{
A dataframe of the details of each segment effort
}
\description{
Compiles the information of athletes from multiple segments
}
\details{
Uses \code{\link{get_elev_prof}} and \code{\link{compile_seg_effort}} internally to compile efforts of multiple segments
}
\examples{
\dontrun{
# set token
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

# segments to get efforts from - use some parkruns
segments <- c(2269028, 5954625)

# compile segment efforts
segments \%>\% purrr::map_df(., .f = compile_seg_efforts, stoken = my_token, .id = 'id')
}
}
\author{
Daniel Padfield
}
\concept{token}
