% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{simulate.intrinsicCBrSPDEobj}
\alias{simulate.intrinsicCBrSPDEobj}
\title{Simulation of a fractional intrinsic SPDE using the
covariance-based rational SPDE approximation}
\usage{
\method{simulate}{intrinsicCBrSPDEobj}(object, nsim = 1, seed = NULL, integral.constraint = TRUE, ...)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}}

\item{nsim}{The number of simulations.}

\item{seed}{An object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{integral.constraint}{Should the contraint on the integral be done?}

\item{...}{Currently not used.}
}
\value{
A matrix with the \code{nsim} samples as columns.
}
\description{
The function samples a Gaussian random field based using the
covariance-based rational SPDE approximation.
}
