% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.computations.R
\name{update.rSPDEobj}
\alias{update.rSPDEobj}
\title{Update parameters of rSPDEobj objects}
\usage{
\method{update}{rSPDEobj}(
  object,
  user_nu = NULL,
  user_alpha = NULL,
  user_kappa = NULL,
  user_sigma = NULL,
  user_range = NULL,
  user_tau = NULL,
  user_theta = NULL,
  user_m = NULL,
  mesh = NULL,
  loc_mesh = NULL,
  graph = NULL,
  range_mesh = NULL,
  parameterization = NULL,
  ...
)
}
\arguments{
\item{object}{The operator-based rational SPDE approximation,
computed using \code{\link[=matern.operators]{matern.operators()}} with \code{type="operator"}}

\item{user_nu}{If non-null, update the shape parameter
of the covariance function.}

\item{user_alpha}{If non-null, update the fractional order.}

\item{user_kappa}{If non-null, update the range parameter
of the covariance function.}

\item{user_sigma}{If non-null, update the standard deviation of
the covariance function.}

\item{user_range}{If non-null, update the range parameter
of the covariance function.}

\item{user_tau}{If non-null, update the parameter tau.}

\item{user_theta}{If non-null, update the parameter theta, that connects
tau and kappa to the model matrices.}

\item{user_m}{If non-null, update the order of the rational
approximation, which needs to be a positive integer.}

\item{mesh}{An optional inla mesh. Replaces \code{d}, \code{C} and \code{G}.}

\item{loc_mesh}{The mesh locations used to construct the matrices C and G. This option should be provided if one wants to use the \code{rspde_lme()} function and will not provide neither graph nor mesh. Only works for 1d data. Does not work for metric graphs. For metric graphs you should supply the graph using the \code{graph} argument.}

\item{graph}{An optional \code{metric_graph} object. Replaces \code{d}, \code{C} and \code{G}.}

\item{range_mesh}{The range of the mesh. Will be used to provide starting values for the parameters. Will be used if \code{mesh} and \code{graph} are \code{NULL}, and if one of the parameters (kappa or tau for spde parameterization, or sigma or range for matern parameterization) are not provided.}

\item{parameterization}{If non-null, update the parameterization. Only works for stationary models.}

\item{...}{Currently not used.}
}
\value{
It returns an object of class "rSPDEobj. This object contains the
same quantities listed in the output of \code{\link[=matern.operators]{matern.operators()}}.
}
\description{
Function to change the parameters of a rSPDEobj object
}
\examples{
# Compute the operator-based rational approximation of a
# Gaussian process with a Matern covariance function on R
kappa <- 10
sigma <- 1
nu <- 0.8
range <- sqrt(8*nu)/kappa

# create mass and stiffness matrices for a FEM discretization
x <- seq(from = 0, to = 1, length.out = 101)
fem <- rSPDE.fem1d(x)

# compute rational approximation of covariance function at 0.5
op <- matern.operators(
  loc_mesh = x, nu = nu,
  range = range, sigma = sigma, d = 1, m = 2, type = "operator",
  parameterization = "matern"
)
op

# Update the range parameter of the model:
op <- update(op, user_kappa = 20)
op

}
\seealso{
\code{\link[=simulate.rSPDEobj]{simulate.rSPDEobj()}}, \code{\link[=matern.operators]{matern.operators()}}
}
