% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rspde_lme.R
\name{predict.rspde_lme}
\alias{predict.rspde_lme}
\title{Prediction of a mixed effects regression model on a metric graph.}
\usage{
\method{predict}{rspde_lme}(
  object,
  data = NULL,
  loc = NULL,
  mesh = FALSE,
  which_repl = NULL,
  compute_variances = FALSE,
  posterior_samples = FALSE,
  n_samples = 100,
  only_latent = FALSE,
  edge_number = "edge_number",
  distance_on_edge = "distance_on_edge",
  normalized = FALSE,
  return_as_list = FALSE,
  return_original_order = TRUE,
  ...
)
}
\arguments{
\item{object}{The fitted object with the \code{rspde_lme()} function}

\item{data}{A \code{data.frame} or a \code{list} containing the covariates, the edge number and the distance on edge
for the locations to obtain the prediction.}

\item{loc}{Prediction locations. Can either be a \code{data.frame}, a \code{matrix} or a character vector, that contains the names of the columns of the coordinates of the locations. For models using \code{metric_graph} objects, plase use \code{edge_number} and \code{distance_on_edge} instead.}

\item{mesh}{Obtain predictions for mesh nodes? The graph must have a mesh, and either \code{only_latent} is set to TRUE or the model does not have covariates.}

\item{which_repl}{Which replicates to use? If \code{NULL} all replicates will be used.}

\item{compute_variances}{Set to also TRUE to compute the kriging variances.}

\item{posterior_samples}{If \code{TRUE}, posterior samples will be returned.}

\item{n_samples}{Number of samples to be returned. Will only be used if \code{sampling} is \code{TRUE}.}

\item{only_latent}{Should the posterior samples and predictions be only given to the latent model?}

\item{edge_number}{Name of the variable that contains the edge number, the default is \code{edge_number}.}

\item{distance_on_edge}{Name of the variable that contains the distance on edge, the default is \code{distance_on_edge}.}

\item{normalized}{Are the distances on edges normalized?}

\item{return_as_list}{Should the means of the predictions and the posterior samples be returned as a list, with each replicate being an element?}

\item{return_original_order}{Should the results be return in the original (input) order or in the order inside the graph?}

\item{...}{Not used.}
}
\description{
Prediction of a mixed effects regression model on a metric graph.
}
