% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safely_transform_data.R
\name{safely_transform_data}
\alias{safely_transform_data}
\title{Performing Transformations on All Features in the Dataset}
\usage{
safely_transform_data(safe_extractor, data, verbose = TRUE)
}
\arguments{
\item{safe_extractor}{object containing information about variables transformations created with safe_extraction() function}

\item{data}{data for which features are to be transformed}

\item{verbose}{logical, if progress bar is to be printed}
}
\value{
data with extra columns containing newly created variables
}
\description{
The safely_transform_data() function creates new variables in dataset
using safe_extractor object.
}
\examples{

library(DALEX)
library(randomForest)
library(rSAFE)

data <- apartments[1:500,]
set.seed(111)
model_rf <- randomForest(m2.price ~ construction.year + surface + floor +
                           no.rooms + district, data = data)
explainer_rf <- explain(model_rf, data = data[,2:6], y = data[,1])
safe_extractor <- safe_extraction(explainer_rf, verbose = FALSE)
safely_transform_data(safe_extractor, data, verbose = FALSE)

}
\seealso{
\code{\link{safe_extraction}}, \code{\link{safely_select_variables}}
}
