% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_client.R
\name{RequestOptions}
\alias{RequestOptions}
\title{Define Request Options for RCSB PDB Search Queries}
\usage{
RequestOptions(
  result_start_index = NULL,
  num_results = NULL,
  sort_by = "score",
  desc = TRUE
)
}
\arguments{
\item{result_start_index}{An integer specifying the starting index for result pagination. If `NULL`, pagination is not applied.}

\item{num_results}{An integer specifying the number of results to return. If `NULL`, the default number of results is returned.}

\item{sort_by}{A string indicating the attribute to sort the results by. The default value is 'score', which ranks results based on relevance.}

\item{desc}{A boolean indicating whether the sorting should be in descending order. Default is `TRUE`.}
}
\value{
A list of request options that can be included in a search query to control the results.
}
\description{
The `RequestOptions` function sets various options for search requests to the RCSB PDB, such as pagination and sorting preferences.
These options help control the volume of search results returned and the order in which they are presented.
}
\examples{
\donttest{
options <- RequestOptions(result_start_index = 0, num_results = 100, sort_by = "score", desc = TRUE)
}
}
