% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_info}
\alias{get_info}
\title{Retrieve Information for a Given PDB ID}
\usage{
get_info(pdb_id, url_root = "https://data.rcsb.org/rest/v1/core/entry/")
}
\arguments{
\item{pdb_id}{A 4-character string specifying a PDB entry of interest.}

\item{url_root}{The root URL for the specific request type. Default is 'https://data.rcsb.org/rest/v1/core/entry/'.}
}
\value{
An ordered dictionary (list in R) object corresponding to entry information.
        Returns NULL if retrieval fails.
}
\description{
This function looks up all information about a given PDB ID using the REST API.
It handles JSON data and HTTP requests and converts old entry identifiers.
}
\examples{
get_info(pdb_id = "4HHB")
}
