% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_generics.R, R/ODESolver.R,
%   R/AbstractODESolver.R, R/DormandPrince45.R, R/Euler.R, R/EulerRichardson.R,
%   R/RK4.R, R/Verlet.R
\docType{methods}
\name{step}
\alias{step}
\alias{step,ODESolver-method}
\alias{step,AbstractODESolver-method}
\alias{step,DormandPrince45-method}
\alias{step,Euler-method}
\alias{step,EulerRichardson-method}
\alias{step,RK4-method}
\alias{step,Verlet-method}
\title{Advances a step in the ODE solver}
\usage{
step(object, ...)

\S4method{step}{ODESolver}(object, ...)

\S4method{step}{AbstractODESolver}(object, ...)

\S4method{step}{DormandPrince45}(object, ...)

\S4method{step}{Euler}(object, ...)

\S4method{step}{EulerRichardson}(object, ...)

\S4method{step}{RK4}(object, ...)

\S4method{step}{Verlet}(object, ...)
}
\arguments{
\item{object}{a class object}

\item{...}{additional parameters}
}
\description{
Advances a step in the ODE solver
}
\examples{
# +++++++++++++++++++++++++++++++++++++++++++++++++++ application: ReactionApp.R
# ReactionApp solves an autocatalytic oscillating chemical
# reaction (Brusselator model) using
# a fourth-order Runge-Kutta algorithm.

importFromExamples("Reaction.R")      # source the class

ReactionApp <- function(verbose = FALSE) {
    X <- 1; Y <- 5;
    dt <- 0.1

    reaction <- Reaction(c(X, Y, 0))
    solver <- RK4(reaction)
    rowvec <- vector("list")
    i <- 1
    while (solver@ode@state[3] < 100) {             # stop at t = 100
        rowvec[[i]] <- list(t = solver@ode@state[3],
                            X = solver@ode@state[1],
                            Y = solver@ode@state[2])
        solver <- step(solver)
        i <-  i + 1
    }
    DT <- data.table::rbindlist(rowvec)
    return(DT)
}


solution <- ReactionApp()
plot(solution)


}
