% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.HE.Vg.Ve.R
\name{MVP.HE.Vg.Ve}
\alias{MVP.HE.Vg.Ve}
\title{To estimate variance component using HE regression}
\usage{
MVP.HE.Vg.Ve(y, X, K)
}
\arguments{
\item{y}{phenotype}

\item{X}{genotype}

\item{K}{kinship matrix}
}
\value{
vg, ve, and delta
}
\description{
Build date: Feb 2, 2017
Last update: Feb 2, 2019
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

K <- MVP.K.VanRaden(genotype, cpu=1)
vc <- MVP.HE.Vg.Ve(y=phenotype[,2], X=matrix(1, nrow(phenotype)), K=K)
print(vc)
}

}
\author{
Translated from C++(GEMMA, Xiang Zhou) to R by: Haohao Zhang
}
