% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrownMetrics.R
\name{CrownMetrics}
\alias{CrownMetrics}
\title{LiDAR-derived individual tree crown metrics}
\usage{
CrownMetrics(xyziId)
}
\arguments{
\item{xyziId}{A 5-column matrix with the x, y, z coordinates, intensity and the tree id classification for the LiDAR point cloud.}
}
\value{
Returns A matrix of the LiDAR-based metrics for the individual tree detected.
}
\description{
Compute individual tree crown metrics from lidar data
}
\details{
# List of the individual tree crown metrics:
\itemize{ 
\item TotalReturns: Total number of returns   
\item ETOP - UTM Easting coordinate of the tree top
\item NTOP - UTM Northing coordinate of the tree top
\item EMIN - Minimum UTM Easting coordinate
\item NMIN - Minimum UTM Northing coordinate
\item EMAX - Maximum UTM Easting coordinate
\item NMAX - Maxmium UTM Northing coordinate
\item EWIDTH - Tree crown width 01
\item NWIDTH - Tree crown width 02
\item HMAX - Maximum Height
\item HMEAN - Mean height
\item HSD - Standard deviation of height
\item HCV - Coefficient of variation of height
\item HMOD - Mode of height
\item H5TH - 5th percentile of height
\item H10TH - 10th percentile of height
\item H20TH - 20th percentile of height
\item H25TH - 25th percentile of height
\item H30TH - 30th percentile of height
\item H40TH - 40th percentile of height
\item H50TH - 50th percentile of height
\item H60TH - 60th percentile of height
\item H70TH - 70th percentile of height
\item H75TH - 75th percentile of height
\item H80TH - 80th percentile of height
\item H90TH - 90th percentile of height
\item H95TH - 95th percentile of height
\item H99TH - 99th percentile of height
\item IMAX - Maximum intensity
\item IMEAN - Mean intensity
\item ISD - Standard deviation of intensity
\item ICV - Coefficient of variation of intensity
\item IMOD - Mode of intensity
\item I5TH - 5th percentile of intensity
\item I10TH - 10th percentile of intensity
\item I20TH - 20th percentile of intensity
\item I25TH - 25th percentile of intensity
\item I30TH - 30th percentile of intensity
\item I40TH - 40th percentile of intensity
\item I50TH - 50th percentile of intensity
\item I60TH - 60th percentile of intensity
\item I70TH - 70th percentile of intensity
\item I75TH - 75th percentile of intensity
\item I80TH - 80th percentile of intensity
\item I90TH - 90th percentile of intensity
\item I95TH - 95th percentile of intensity
\item I99TH - 99th percentile of intensity
}
}
\examples{

#=======================================================================#
# Individual tree detection using K-means cluster
#=======================================================================#
# Importing LAS file:
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Reading LAS file
LAS<-readLAS(LASfile,short=TRUE)

# Setting the xyz coordinates and subsetting the data
xyzi<-subset(LAS[,1:4],LAS[,3] >= 1.37)

# Finding clusters (trees)
clLAS<-kmeans(xyzi[,1:2], 32)

# Set the tree id vector
Id<-as.factor(clLAS$cluster)

# Combining xyzi and tree id 
xyziId<-cbind(xyzi,Id)

#=======================================================================#
#  Computing individual tree LiDAR metrics 
#=======================================================================#

TreesMetrics<-CrownMetrics(xyziId)
head(TreesMetrics)
}
\author{
Carlos Alberto Silva
}
