\name{wedderburn.number}
\alias{wedderburn.number}

\title{
Calculates Wedderburn Number for a lake.
}
\description{ Wedderburn Number (Wn) is a dimensionless parameter measuring the balance between 
wind stress and bouyancy force and is used to estimate the amount of upwelling occuring in a lake. 
When Wn is much greater than 1, the bouyancy force is much greater than the wind stress and therefore there is a strong vertical stratification with little horizontal variation in the stratification. When Wn is much less than 1, the wind stress is much greater than the bouyancy force and upwelling is likely occuring at the upwind end of the lake. When Wn is near 1, the bouyance force and wind stress are nearly equal and horizontal mixing is considered important}
\usage{
wedderburn.number(delta_rho, metaT, uSt, Ao, AvHyp_rho)
}

\arguments{
  \item{delta_rho}{ Numeric value for the water density difference between the epilimnion and hypolimnion (kg/m^3)}
  \item{metaT}{ Numeric value for the thickness of the water body's surface layer (m)}
  \item{uSt}{ Numeric value for the water friction velocity due to wind stress (m/s)}
  \item{Ao}{ Numeric value for the water body surface area (m^2) at zero meters depth}
  \item{AvHyp_rho}{ Numeric value for the average water density of the hypolimnion layer (kg/m^3)}
}

\value{ The dimensionless numeric value of Wedderburn Number}
\references{
Imberger, J., Patterson, J.C., 1990. \emph{Physical limnology}. Advances in Applied
Mechanics 27, 353-370.
}
\author{Jake Zwart}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
	\code{\link{ts.wedderburn.number}}
	\code{\link{lake.number}}
}

\examples{
delta_rho <- c(3.1,1.5)
metaT <- c(5.5,2.4)
uSt <- c(0.0028,0.0032)
Ao <- c(80300,120000)
AvHyp_rho <- c(999.31,999.1)
wedderburn.number(delta_rho, metaT, uSt, Ao, AvHyp_rho)
}

\keyword{arith}
