% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.seqs.R
\name{msc.seqs}
\alias{msc.seqs}
\title{Retrieve sequences}
\usage{
msc.seqs(fastafile, ucfile, clustnumbers, writeDNA = TRUE)
}
\arguments{
\item{fastafile}{the name of the fasta file containing all minicircle sequences.}

\item{ucfile}{the name of the uc file.}

\item{clustnumbers}{a character vector containing the cluster numbers (in the format "C0", "C1", ...) of which cluster and hit sequences need to be extracted.}

\item{writeDNA}{a logical parameter which is by default set to TRUE. This will write fasta files to the current directory.}
}
\value{
a table which summarizes the number of hit sequences found in the MSC, the MSC name and where the MSC is present (strain names).

one fasta file per MSC with all its hits sequences.
}
\description{
The msc.seqs retrieves the DNA sequence of a minicircle sequence cluster (MSC) together with all its hit sequences.
}
\examples{
data(exData)

### select a subset of MSC
Lpe <- which(exData$species == "L. peruviana")
specific <- msc.subset(matrices[[7]], subset = Lpe)

### run function
seq <- msc.seqs(fastafile = system.file("extdata", "all.minicircles.circ.fasta", package="rKOMICS"),
                ucfile = system.file("extdata", exData$ucs, package="rKOMICS")[7], 
                clustnumbers = specific$clustnumbers, writeDNA = FALSE)

}
