% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.subset.R
\name{msc.subset}
\alias{msc.subset}
\title{Specific MSC}
\usage{
msc.subset(clustmatrix, subset)
}
\arguments{
\item{clustmatrix}{a cluster matrix}

\item{subset}{a numerical vector indicating which subset of samples to include.}
}
\value{
\item{clustnumbers}{a vector containing the specific MSC names.}
\item{freq}{frequency values of those specific MSC in the subset of samples.}
\item{matrix}{a subset of the cluster matrix containing only those specific MSC. All samples, not in the subset, should have a value of 0 meaning the MSC is absent.}
\item{sum}{the total number of MSC found in the indicated subset of samples.}
}
\description{
The msc.subset allows you to find specific MSC for a certain subset of samples.
}
\examples{
data(matrices)
data(exData)

### selecting a group of samples e.g. all L. peruviana species
Lpe <- which(exData$species == "L. peruviana")

### run function
specific <- msc.subset(matrices[["id97"]], subset = Lpe)

### visualize results (check if it is indeed specific)
heatmap(specific$matrix) # or:
msc.heatmap(specific$matrix, samples = exData$samples, groups = exData$species)

### find specific MSC with highest frequency
which.max(specific$freq)

}
