% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getipintel.R
\name{getipintel}
\alias{getipintel}
\title{Retrieve IP address metadata from GetIPIntel}
\usage{
getipintel(ip, flags = NULL, oflags = NULL,
  contact_info = getipintel_contact_info())
}
\arguments{
\item{ip}{an IP address (length 1 character vector)}

\item{flags, oflags}{a valid GetIPIntel flag specification (See: \url{https://getipintel.net/free-proxy-vpn-tor-detection-api/#optional_settings})}

\item{contact_info}{GetIPIntel requires supplying contact info with each API call. Presently,
this takes the form of an email address. See \code{\link[=getipintel_contact_info]{getipintel_contact_info()}} for more information.}
}
\description{
Retrieve IP address metadata from GetIPIntel
}
\examples{
\dontrun{
getipintel("24.63.157.68")
}
}
\references{
\url{https://getipintel.net/}
}
\author{
Bob Rudis (bob@rud.is)
}
