% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_01_to_event_table_wf_all.r
\name{f_to_event_table_wf_all}
\alias{f_to_event_table_wf_all}
\title{Data transformation: Wide format -> Event format required for the model}
\usage{
f_to_event_table_wf_all(formula, data, id_name, doses, times, covars)
}
\arguments{
\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{input data set - event format data set}

\item{id_name}{name of variable containing the names of subjects}

\item{doses}{sub data set of grouped doses}

\item{times}{sub data set of times relatives to doses}

\item{covars}{sub data set of the covars that will be involved in the model}
}
\value{
The data set with the event-row format, including the event of exit of the cohort
}
\description{
This function organize an input data set wf (wide format, same input as in Epicrue Peanuts), to the required ef data set for the model.
It appends an index of person event 1,2..n,0 if a subject has n doses (or grouped doses), and being the 0-row the exit conditions: exit time, exit dose and the outcome.
Also creates the cumulated dose.
}
\examples{
\donttest{f_to_event_table_wf_all(formula,data,id_name='patientids',doses=data[,31:50],
                             times=data[,11:30],covars=data[,c('sex','country','birthcohort')])}
}
