% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.writeup.R
\name{ena.writeup}
\alias{ena.writeup}
\title{Calculate the correlations}
\usage{
ena.writeup(enaset, tool = "rENA",
  tool.version = as.character(packageVersion(tool)), comparison = NULL,
  comparison.groups = NULL, sig.dig = 2, output_dir = getwd(),
  type = c("file", "stream"), theory = T, methods = T)
}
\arguments{
\item{enaset}{ENAset to view methods of}

\item{tool}{c("rENA","webENA")}

\item{tool.version}{as.character(packageVersion(tool))}

\item{comparison}{character string representing the comparison used, c(NULL, "parametric", "non-parametric"). Default NULL}

\item{comparison.groups}{Groups that were used for the comparison}

\item{sig.dig}{Integer for the number of digits to round to}

\item{output_dir}{Where to save the output file}

\item{type}{c("file","stream") File will save to a file in output_dir, Stream returns the contents directly}

\item{theory}{Logical indicating whether to include theory in the writeup}

\item{methods}{Logical indicating whether to include methods in the writeup}
}
\value{
String representing the methods used to generate the model
}
\description{
Calculate both Spearman and Pearson correlations for the
provided ENAset
}
