% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprd_medcodes.R
\name{read_to_medcodes}
\alias{read_to_medcodes}
\title{Translate Read/Oxmis codes to CPRD medcodes}
\usage{
read_to_medcodes(readcodes_data, lookup_table, readcodes_name = "readcode",
  lookup_readcodes = "readcode", lookup_medcodes = "medcode", description)
}
\arguments{
\item{readcodes_data}{a dataframe with a column matching medcodes_name}

\item{lookup_table}{a dataframe with columns matching lookup_readcodes and lookup_medcodes}

\item{readcodes_name}{character name of the Read codes column in readcodes_data}

\item{lookup_readcodes}{character name of the Read codes column in the lookup_table}

\item{lookup_medcodes}{character name of the CPRD medcodes column in the lookup_table}

\item{description}{logical Should description and other categories from the lookup table also be included?}
}
\value{
a data frame matching the input medcodes_data with the Read codes and optional description columns merged in.
}
\description{
This function accepts a data frame with a column for Read/Oxmis codes and merges with a medical lookup table to give columns for CPRD medcodes and optional descriptions
}
\details{
Note that if the names of the Read/Oxmis codes columns are different in the data and the lookup table, the name in the data is retained
To maintain sanity, a warning will be given to inform of are any name conflicts between the input data and the lookup
}

