% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_tests.R
\name{test_nonlinearity}
\alias{test_nonlinearity}
\title{Randomization test for nonlinearity using S-maps and surrogate data}
\usage{
test_nonlinearity(ts, method = "ebisuzaki", num_surr = 200,
  T_period = 1, E = 1, ...)
}
\arguments{
\item{ts}{the original time series}

\item{method}{which algorithm to use to generate surrogate data}

\item{num_surr}{the number of null surrogates to generate}

\item{T_period}{the period of seasonality for seasonal surrogates 
(ignored for other methods)}

\item{E}{the embedding dimension for s_map}

\item{...}{optional arguments to s_map}
}
\value{
A data.frame containing the following components:
\tabular{ll}{
  \code{delta_rho} \tab the value of the delta rho statistic\cr
  \code{delta_mae} \tab the value of the delat mae statistic\cr
  \code{num_surr} \tab the size of the null distribution\cr
  \code{delta_rho_p_value} \tab the p-value for delta rho\cr
  \code{delta_mae_p_value} \tab the p-value for delta mae\cr
}
}
\description{
\code{\link{test_nonlinearity}} tests for nonlinearity using S-maps by 
comparing improvements in forecast skill (delta rho and delta mae) between 
linear and nonlinear models with a null distribution from surrogate data.
}
