% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build}
\alias{build}
\title{Build classifier function (Apriori-based)}
\usage{
build(trainData, className = NA, pruning = TRUE, sa = list())
}
\arguments{
\item{trainData}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{className}{column name with the target class - default is the last column}

\item{pruning}{performing pruning while building the model}

\item{sa}{simulated annealing setting. Default values: list(temp=100.0, alpha=0.05, tabuRuleLength=5, timeout=10)}
}
\value{
list with parameters and model as data.frame with rules
}
\description{
Automatic build of the classification model using the Apriori algorithm from the \code{arules}
}
\examples{
library("rCBA")
data("iris")

output <- rCBA::build(iris,sa = list(alpha=0.5)) # speeding up the cooling
model <- output$model

predictions <- rCBA::classification(iris, model)
table(predictions)
sum(iris$Species==predictions, na.rm=TRUE) / length(predictions)

}
