/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration
class JacksonHttpMessageConvertersConfiguration {
    JacksonHttpMessageConvertersConfiguration() {
    }

    @Configuration
    @ConditionalOnClass(value={XmlMapper.class})
    @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    protected static class MappingJackson2XmlHttpMessageConverterConfiguration {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        protected MappingJackson2XmlHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MappingJackson2XmlHttpMessageConverter mappingJackson2XmlHttpMessageConverter(Jackson2ObjectMapperBuilder builder) {
            MappingJackson2XmlHttpMessageConverter converter = new MappingJackson2XmlHttpMessageConverter();
            converter.setObjectMapper(builder.createXmlMapper(true).build());
            if (this.properties.isJsonPrettyPrint() != null) {
                converter.setPrettyPrint(this.properties.isJsonPrettyPrint().booleanValue());
            }
            return converter;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    protected static class MappingJackson2HttpMessageConverterConfiguration {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        protected MappingJackson2HttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
            MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(objectMapper);
            if (this.properties.isJsonPrettyPrint() != null) {
                converter.setPrettyPrint(this.properties.isJsonPrettyPrint().booleanValue());
            }
            return converter;
        }
    }
}

