% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projWiz.R
\name{simProjWiz}
\alias{simProjWiz}
\title{Simple Projection Wizard}
\usage{
simProjWiz(thepoints, thecentre)
}
\arguments{
\item{thepoints}{set of points in latitude and longtitude ie c(lat,long)}

\item{thecentre}{one point ie c(lat,long)}
}
\value{
set of points in metres (x,y)
}
\description{
Projects any set of lat long points to a "suitable" area projection, based on it's "true centre of gravity"
}
\details{
Simple equal area projection wizard
}
\note{
Based around a simple continental projection, using two sets of projections
equal area cylindrical = Cylindrical equal-area = 8287
equal area azimuthal for polar (above 70) = Lambert azimuthal equal-area
 
note these are not cartographically pleasing projections, they are just so we can get the data into something simple for areal analysis
See below for a more cartographically pleasing projection engine

Šavric, B., Jenny, B., Jenny, H., 2016. Projection Wizard – An Online Map Projection Selection Tool. Cartogr. J. 53, 1–9. doi:10.1080/00087041.2015.1131938
}
\examples{
lat <- runif (200,-24,-12)
long <- runif (200,43,51)
ll <- data.frame(lat,long)
cp <- trueCOGll(ll)
pointsprojected <- simProjWiz(ll,cp)
}
\author{
Justin Moat. J.Moat@kew.org
}
\references{
Šavric, B., Jenny, B., Jenny, H., 2016. Projection Wizard – An Online Map Projection Selection Tool. Cartogr. J. 53, 1–9. doi:10.1080/00087041.2015.1131938

Snyder, J.P., 1987. Map projections: A working manual, Professional Paper. Washington, D.C.
}

