% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{amTooltip}
\alias{amTooltip}
\title{Tooltip}
\usage{
amTooltip(
  text,
  textColor = NULL,
  textAlign = "middle",
  backgroundColor = NULL,
  backgroundOpacity = 0.6,
  borderColor = NULL,
  borderWidth = 2,
  pointerLength = 10,
  scale = 1,
  auto = FALSE
)
}
\arguments{
\item{text}{text to display in the tooltip; this should be a
\href{https://www.amcharts.com/docs/v4/concepts/formatters/formatting-strings/}{formatting string}}

\item{textColor}{text color}

\item{textAlign}{alignement of the text, can be \code{"start"},
\code{"middle"}, or \code{"end"}}

\item{backgroundColor}{background color of the tooltip}

\item{backgroundOpacity}{background opacity}

\item{borderColor}{color of the border of the tooltip}

\item{borderWidth}{width of the border of the tooltip}

\item{pointerLength}{length of the pointer}

\item{scale}{scale factor}

\item{auto}{logical, whether to use automatic background color and text color}
}
\value{
A list of settings for a tooltip.
}
\description{
Create list of settings for a tooltip.
}
\note{
A color can be given by the name of a R color, the name of a CSS
  color, e.g. \code{"transparent"} or \code{"fuchsia"}, an HEX code like
  \code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
  like \code{"hsl(360,11,255)"}.
}
