% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_AmGraph.R
\docType{methods}
\name{initialize,AmGraph-method}
\alias{initialize,AmGraph-method}
\alias{amGraph}
\alias{graph}
\alias{setBalloonText}
\alias{setBalloonText,AmGraph,character-method}
\alias{setTitle,AmGraph,character-method}
\alias{setType,AmGraph,character-method}
\alias{setValueField}
\alias{setValueField,AmGraph,character-method}
\title{Initializes an AmGraph}
\usage{
\S4method{initialize}{AmGraph}(.Object, animationPlayed = FALSE,
  balloonText, title, type, valueField, ...)

amGraph(animationPlayed = FALSE, balloonText, title, type, valueField,
  ...)

graph(animationPlayed = FALSE, balloonText, title, type, valueField, ...)

setBalloonText(.Object, balloonText)

\S4method{setBalloonText}{AmGraph,character}(.Object, balloonText)

\S4method{setTitle}{AmGraph,character}(.Object, title)

\S4method{setType}{AmGraph,character}(.Object, type)

setValueField(.Object, valueField)

\S4method{setValueField}{AmGraph,character}(.Object, valueField)
}
\arguments{
\item{.Object}{\linkS4class{AmGraph}.}

\item{animationPlayed}{\code{logical}.}

\item{balloonText}{\code{character}, 
balloon text. You can use tags like [[value]], [[description]], [[percents]], [[open]], [[category]]
or any other field name from your data provider. HTML tags can also be used.}

\item{title}{\code{character}, graph title.}

\item{type}{\code{character}, 
type of the graph. Possible values are: "line", "column", "step", "smoothedLine", "candlestick", "ohlc".
XY and Radar charts can only display "line" otherArguments graphs.}

\item{valueField}{\code{character}, 
name of the value field in your dataProvider.}

\item{...}{other properties of AmGraph.
See \url{http://docs.amcharts.com/3/javascriptcharts/AmGraph}.}
}
\value{
An object of class \linkS4class{AmGraph} with the given properties.
}
\description{
To create an AmGraph, you can use the usual methode
Initialize or the constructor.
You can update properties with setters.
}
\examples{
# --- method 'initialize'
new("AmGraph", valueField = "value")

# constructor
amGraph(balloonText = "My text")
\dontrun{
amGraph(balloonText = "balloonText", "type" = "column", title = "myGraph!",
        valueField = "value", animationPlayed = TRUE, other = TRUE)
}
amGraph(balloonText = "some text")
# --- shortcut constructor
graph(balloonText = "balloonText", "type" = "column",
      valueField = "value", animationPlayed = TRUE)
      
# --- update 'balloonText'
setBalloonText(.Object = amGraph(), balloonText = "performance")

# --- update 'title'
setTitle(.Object = amGraph(), title = "Power")

# --- update 'type'
setType(.Object = amGraph(), type = "type")

# --- update valueField
setValueField(.Object = amGraph(), valueField = "score")

}
