% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GaugeArrow.R, R/GaugeArrow_setters.R
\docType{methods}
\name{initialize,GaugeArrow-method}
\alias{gaugeArrow}
\alias{initialize,GaugeArrow-method}
\alias{setAxis}
\alias{setAxis,GaugeArrow,GaugeAxisOrCharacterOrMissing-method}
\title{Initialize a GaugeArrow}
\usage{
\S4method{initialize}{GaugeArrow}(.Object, alpha = 1, axis, ...)

gaugeArrow(alpha = 1, axis, ...)

setAxis(.Object, axis = NULL, ...)

\S4method{setAxis}{GaugeArrow,GaugeAxisOrCharacterOrMissing}(.Object,
  axis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{GaugeArrow}.}

\item{alpha}{\code{numeric}.}

\item{axis}{\linkS4class{GaugeAxis}.
Axis of the arrow. You can use reference to the axis or id of the axis.
If you don't set any axis, the first axis of a chart will be used.}

\item{...}{Other properties.}
}
\value{
(updated) .Object of class \linkS4class{GaugeArrow}.
}
\description{
Initialize a GaugeArrow
}
\section{Functions}{
\itemize{
\item \code{gaugeArrow}: 
}}
\examples{
new("GaugeArrow")
gaugeArrow(value = 10)
setAxis(.Object = gaugeArrow(), id = "axis1", startValue = 0,
        endValue = 100, valueInterval = 10)
# equivalent to:
axis_obj <- gaugeAxis(id = "axis1", startValue = 0, endValue = 100, valueInterval = 10)
setAxis(.Object = gaugeArrow(), axis = axis_obj)
# or, iff, 'axis_obj' has already been added to the chart
setAxis(.Object = gaugeArrow(), axis = "axis1")
# ---
}

