% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotYield.R
\name{SSplotYield}
\alias{SSplotYield}
\title{Plot yield and surplus production.}
\usage{
SSplotYield(replist, subplots = 1:3, refpoints = c("MSY", "Btgt",
  "SPR", "Current"), add = FALSE, plot = TRUE, print = FALSE,
  labels = c("Fraction unfished", "Equilibrium yield (mt)",
  "Total biomass (mt)", "Surplus production (mt)"), col = "blue",
  col2 = "black", lty = 1, lwd = 2, cex.main = 1, pwidth = 6.5,
  pheight = 5, punits = "in", res = 300, ptsize = 10,
  plotdir = "default", verbose = TRUE)
}
\arguments{
\item{replist}{list created by \code{SS_output}}

\item{subplots}{vector controlling which subplots to create
Numbering of subplots is as follows:
\itemize{
  \item 1 yield curve
  \item 2 yield curve with reference points
  \item 3 surplus production vs. biomass plots (Walters et al. 2008) 
}}

\item{refpoints}{character vector of which reference points to display in
subplot 2, from the options 'MSY', 'Btgt', and 'SPR'.}

\item{add}{add to existing plot? (not yet implemented)}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{col}{line color for equilibrium plot}

\item{col2}{line color for dynamic surplus production plot}

\item{lty}{line type (only applied to equilbrium yield plot at this time)}

\item{lwd}{line width (only applied to equilbrium yield plot at this time)}

\item{cex.main}{character expansion for plot titles}

\item{pwidth}{width of plot}

\item{pheight}{height of plot}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{point size for PNG file}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{verbose}{report progress to R GUI?}
}
\description{
Plot yield and surplus production from Stock Synthesis output. Surplus
production is based on Walters et al. (2008).
}
\references{
Walters, Hilborn, and Christensen, 2008, Surplus production
dynamics in declining and recovering fish populations.  Can. J. Fish. Aquat.
Sci. 65: 2536-2551
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\author{
Ian Stewart, Ian Taylor
}
