% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_ForeCatch.R
\name{SS_ForeCatch}
\alias{SS_ForeCatch}
\title{Create table of fixed forecast catches}
\usage{
SS_ForeCatch(replist, yrs = 2017:2026, average = FALSE,
  avg.yrs = 2010:2014, total = NULL, digits = 2, dead = TRUE)
}
\arguments{
\item{replist}{List created by \code{\link{SS_output}}}

\item{yrs}{Range of years in which to fill in forecast catches from timeseries}

\item{average}{Use average catch over a range of years for forecast
(as opposed to using forecast based on control rule)}

\item{avg.yrs}{Range of years to average over}

\item{total}{Either single value or vector of annual total forecast catch
used to scale values (especially if values are from average catches).
For west coast groundfish, total might be ACL for next 2 forecast years}

\item{digits}{Number of digits to round to in table}

\item{dead}{TRUE/FALSE switch to choose dead catch instead of retained catch.}
}
\description{
Processing values of dead or retained bimoass from timeseries output
to fit the format required at the bottom of the forecast file.
This can be used to map the catches resulting from forecasting with a particular
harvest control rule into a model representing a different state of nature.
This is a common task for US west coast groundfish but might be useful elsewhere.
}
\examples{

  \dontrun{
    # create table for next two hears based on 
    SS_ForeCatch(base,               # object created by SS_output
                 yrs=2015:2016,      # years with fixed catch
                 average=TRUE,       # catch by fleet from average catch
                                     # (not harvest control rule)
                 avg.yrs=2010:2014,  # use average of catches over past 5 years
                 total=c(6.6,6.8))   # scale totals equal to ACLs (from John DeVore)

    # create table based on harvest control rule projection in SS
    # that can be mapped into an alternative state of nature
    SS_ForeCatch(low_state,          # object created by SS_output for low state 
                 yrs=2017:2026,      # forecast period after fixed ACL years
                 average=FALSE)      # use values forecast in SS, not historic catch

  }

}
\author{
Ian G. Taylor
}
\seealso{
\code{\link{SS_readforecast}}, \code{\link{SS_readforecast}}
}

