% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SSplotSpawnrecruit}
\alias{SSplotSpawnrecruit}
\title{Plot spawner-recruit curve.}
\usage{
SSplotSpawnrecruit(replist, subplot = 1:2, add = FALSE, plot = TRUE,
  print = FALSE, xlim = NULL, ylim = NULL,
  xlab = "Spawning biomass (mt)", ylab = "Recruitment (1,000s)",
  bioscale = "default", plotdir = "default", pwidth = 7, pheight = 7,
  punits = "in", res = 300, ptsize = 12, cex.main = 1, verbose = TRUE,
  line1 = "blue", line2 = "green3", line3 = "black", minyr = "default",
  textmindev = 0.5, ptcol = "red", virg = TRUE, init = FALSE,
  forecast = FALSE)
}
\arguments{
\item{replist}{list created by \code{SS_output}}

\item{subplot}{vector of which subplots to show.  1=plot without labels,
2=plot with year labels.}

\item{add}{add to existing plot?}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{xlim}{optional control of x range}

\item{ylim}{optional control of y range}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{bioscale}{multiplier on spawning biomass, set to 0.5 for single-sex
models}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{pwidth}{width of plot written to PNG file}

\item{pheight}{height of plot written to PNG file}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{ptsize for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{verbose}{report progress to R GUI?}

\item{line1}{first line color}

\item{line2}{second line color}

\item{line3}{third line color}

\item{minyr}{minimum year of recruitment deviation to show in plot}

\item{textmindev}{minimum recruitment deviation for label to be added so
only extreme devs are labeled (labels are added to first and last years as
well).  Default=0.7.}

\item{ptcol}{point color}

\item{virg}{add point for equilibrium conditions (x=B0,y=R0)}

\item{init}{add point for initial conditions (x=B1,y=R1)}

\item{forecast}{include forecast years in the curve?}
}
\description{
Plot spawner-recruit curve based on output from Stock Synthesis model.
}
\author{
Ian Stewart, Ian Taylor
}
\seealso{
\code{\link{SS_plots}}, \code{\link{SS_output}}
}
\keyword{hplot}

