% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sel.R
\name{m_sel}
\alias{m_sel}
\title{Selection Function for r3dmol}
\usage{
m_sel(
  model = NULL,
  resi = NULL,
  resn = NULL,
  invert = NULL,
  byres = NULL,
  expand = NULL,
  elem = NULL,
  chain = NULL,
  atom = NULL,
  bonds = NULL,
  ss = NULL,
  b = NULL,
  clickable = NULL,
  callback = NULL
)
}
\arguments{
\item{model}{a single model or list of models from which atoms should be
selected. Can also specify by numerical creation order.
Reverse indexing is allowed (-1 specifies last added model).}

\item{resi}{Residue number/s. (vector)}

\item{resn}{Parent residue name as 3-letter code (e.g. "ALA", "GLY",
"CYS"...)}

\item{invert}{Logical, if \code{invert = TRUE}, Inverts the selection
criteria.}

\item{byres}{Logical, if \code{byres = TRUE}, expands the selection to
entire residues that include any selected atoms.}

\item{expand}{Expand selection to include atoms within a specified distance
from current selection.
all atoms of any residue that has any atom already selected.}

\item{elem}{element abbreviation (e.g 'H', 'Ca', etc)}

\item{chain}{String, chain this atom belongs to (e.g. 'A' for chain A)}

\item{atom}{Atom name, may be more specific than 'elem' (e.g. 'CA' for alpha
carbon)}

\item{bonds}{overloaded to select number of bonds, e.g. \code{bonds = 0}
will select all non-bonded atoms}

\item{ss}{Secondary structure identifier. 'h' for helix, 's' for beta-sheet.}

\item{b}{Atom b factor data}

\item{clickable}{Set this flag to true to enable click selection handling
for this atom}

\item{callback}{Callback click handler function to be executed on this atom
and its parent viewer.}
}
\value{
sel \code{list()} for selecting atoms.
}
\description{
Provides documentation for some basic useful selection criteria.
For more advanced selection options, see the
\href{https://3dmol.csb.pitt.edu/doc/types.html#AtomSelectionSpec}{Official
Documenation}
}
\examples{
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_add_style(
    style = m_style_stick(),
    sel = m_sel(resi = 1:2)
  ) \%>\%
  m_zoom_to(sel = m_sel(resi = 1))

# Expand example
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_add_style(
    style = m_style_stick(),
    sel = m_sel(
      resi = 1,
      expand = 10,
      byres = TRUE
    )
  ) \%>\%
  m_zoom_to(sel = m_sel(resi = 1))
}
