% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_cylinder}
\alias{m_add_cylinder}
\title{Add a cylinder shape to scene.}
\usage{
m_add_cylinder(
  id,
  start,
  end,
  radius = 0.1,
  fromCap = 1,
  toCap = 1,
  dashed = FALSE,
  spec = m_shape_spec()
)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()}).}

\item{start}{Start location of cylinder. Can be either \code{m_sel()} or
\code{m_vector3()}.}

\item{end}{End location of cylinder. Can be either \code{m_sel()} or
\code{m_vector3()}.}

\item{radius}{Radius of cylinder.}

\item{fromCap}{Cap at start of cylinder. 0 for none, 1 for flat,
2 for rounded.}

\item{toCap}{Cap at end of cylinder. 0 for none, 1 for flat, 2 for rounded.}

\item{dashed}{Boolean, dashed style cylinder instead of solid.}

\item{spec}{Additional shape specifications defined with
\code{m_shape_spec()}.}
}
\description{
Creates cylinder shape from start to end, with styling spec from
\code{m_shape_spec()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_zoom_to(sel = m_sel(resi = 1)) \%>\%
  m_add_cylinder(
    start = m_sel(resi = 1),
    end = m_sel(resi = 2),
    dashed = TRUE,
    radius = 0.1,
    spec = m_shape_spec(
      color = "green",
      opacity = 0.5
    )
  )
}
