% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_arrow}
\alias{m_add_arrow}
\title{Add arrow shape}
\usage{
m_add_arrow(
  id,
  start,
  end,
  radius = 0.2,
  radiusRatio = 1.62,
  mid = 0.62,
  spec = m_shape_spec(),
  hidden = FALSE
)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{start}{Start location of arrow Can be either \code{m_sel()} or
\code{m_vector3()}.}

\item{end}{End location of arrow. Can be either \code{m_sel()} or
\code{m_vector3()}.}

\item{radius}{Radius of base cylinder for arrow.}

\item{radiusRatio}{Ratio of arrow point to the base cylinder.
Default 1.618034.}

\item{mid}{Relative position of the arrow point base, along the length of
arrow object. Default to 0.618034.}

\item{spec}{Additional shape specifications defined with
\code{m_shape_spec()}.}

\item{hidden}{Hide object if TRUE.}
}
\description{
Add an arrow from start to end, additional customisation through
\code{m_shape_spec()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_zoom_to(sel = m_sel(resi = 1)) \%>\%
  m_add_arrow(
    start = m_sel(resi = 1),
    end = m_sel(resi = 3),
    spec = m_shape_spec(color = "green")
  )
}
