% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_custom}
\alias{m_add_custom}
\title{Add custom shape component from user supplied function}
\usage{
m_add_custom(id, spec)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{spec}{Style specification
(see: \url{http://3dmol.csb.pitt.edu/doc/types.html#CustomShapeSpec}).}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Add custom shape component from user supplied function
}
\examples{
library(r3dmol)

r <- 20

vertices <- list(
  m_vector3(0, 0, 0),
  m_vector3(r, 0, 0),
  m_vector3(0, r, 0)
)

normals <- list(
  m_vector3(0, 0, 1),
  m_vector3(0, 0, 1),
  m_vector3(0, 0, 1)
)

colors <- list(
  list(r = 1, g = 0, b = 0),
  list(r = 0, g = 1, b = 0),
  list(r = 0, g = 0, b = 1)
)

faces <- 0:2

r3dmol() \%>\%
  m_add_custom(spec = list(
    vertexArr = vertices,
    normalArr = normals,
    faceArr = faces,
    color = colors
  ))
}
