% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSPSS}
\alias{plotSPSS}
\title{Scatterplot and Scatterplot Matrix}
\usage{
plotSPSS(data, variables, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{a character vector specifying at least two variables to be
plotted.  In case of two variables, a simple scatterplot is produced with
the first variable on the \eqn{x}-axis and the second variable on the
\eqn{y}-axis.  In case of more than two variables, a scatterplot matrix is
produced.}

\item{xlab, ylab}{the axis labels for a simple scatterplot (the default is
to use the variable names).  This is ignored for a scatterplot matrix.}

\item{\dots}{additional arguments to be passed down, in particular
graphical parameters (see \code{\link[graphics]{par}}).}
}
\value{
Nothing is returned, but a plot is produced.
}
\description{
Draw a scatterplot or a scatterplot matrix of variables in a data frame.
The plots thereby mimic the look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot log market values against age
plotSPSS(Eredivisie, c("Age", "logMarketValue"))

# scatterplot matrix of age, number of minutes played, and
# log market values
plotSPSS(Eredivisie, c("Age", "Minutes", "logMarketValue"))

}
\author{
Andreas Alfons
}
\keyword{hplot}
