% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{descriptives}
\alias{descriptives}
\alias{print.descriptivesSPSS}
\title{Descriptive Statistics}
\usage{
descriptives(data, variables)

\method{print}{descriptivesSPSS}(x, digits = 2, ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying numeric variables for which
to compute descriptive statistics.}

\item{x}{an object of class \code{"descriptivesSPSS"} as returned by
function \code{descriptives}.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the LaTeX table.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"descriptivesSPSS"} with the following components:
\describe{
  \item{\code{classes}}{a character vector giving the (first) class of the
  variables of interest.}
  \item{\code{descriptives}}{a data frame containing the descriptive
  statistics.}
  \item{\code{n}}{an integer giving the number of observations.}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Compute descriptive statistics of numeric variables of a data set (number of
observations, minimum, maximum, mean, standard deviaiton).  The output is
printed as a LaTeX table that mimics the look of SPSS output (version <24).
}
\examples{
# load data
data("Eredivisie")

# compute descriptive statistics for market value and age
descriptives(Eredivisie, c("MarketValue", "Age"))

}
\author{
Andreas Alfons
}
\keyword{univar}
