% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_attributes.R
\name{rtf_source}
\alias{rtf_source}
\title{Add data source attributes to the table}
\usage{
rtf_source(
  tbl,
  source = NULL,
  font = 1,
  format = NULL,
  font_size = 9,
  color = NULL,
  background_color = NULL,
  justification = "c",
  indent_first = 0,
  indent_left = 0,
  indent_right = 0,
  space = 1,
  space_before = 0,
  space_after = 0,
  new_page = FALSE,
  hyphenation = TRUE
)
}
\arguments{
\item{tbl}{A data frame}

\item{source}{data source text}

\item{font}{text font type}

\item{format}{text format}

\item{font_size}{text font size}

\item{color}{text color}

\item{background_color}{text background color}

\item{justification}{justification for text}

\item{indent_first}{first indent}

\item{indent_left}{left indent}

\item{indent_right}{right indent}

\item{space}{paragraph space}

\item{space_before}{line space before text}

\item{space_after}{line space after text}

\item{new_page}{boolean value to indicate whether to start a new page}

\item{hyphenation}{boolean value to indicate whether to use hyphenation}
}
\value{
the same data frame \code{tbl} with additional attributes for data source of a table
}
\description{
Add data source attributes to the table
}
\examples{
library(dplyr) # required to run examples
data(tbl_1)
tbl_1 \%>\% rtf_source("Source: [study999:adam-adeff]") \%>\%
    attr("rtf_source")

}
