% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rtf.R
\name{rtf_encode}
\alias{rtf_encode}
\alias{as_rtf}
\title{Render to RTF Encoding}
\usage{
rtf_encode(tbl, type = "table")

as_rtf(tbl, type = "table")
}
\arguments{
\item{tbl}{a data frame for table or a list of binary string for figure}

\item{type}{the type of input, default is table.}
}
\value{
\preformatted{For \code{rtf_encode}, a vector of RTF code.
For \code{write_rtf}, no return value.
}
}
\description{
This function extracts table/figure attributes and render to RTF encoding that is ready to save
to an RTF file.
}
\examples{

library(dplyr)  # required to run examples

# Example 1
  head(iris) \%>\%
    rtf_body() \%>\%
    rtf_encode() \%>\%
    write_rtf(file = file.path(tempdir(), "table1.rtf"))

# Example 2
  library(dplyr) # required to run examples
  file <- file.path(tempdir(), "figure1.png")
  png(file)
  plot(1:10)
  dev.off()

  # Read in PNG file in binary format
  rtf_read_png(file) \%>\% rtf_figure() \%>\%
    rtf_encode(type = "figure") \%>\%
    write_rtf(file = file.path(tempdir(), "figure1.rtf"))

# Example 3

## convert tbl_1 to the table body. Add title, subtitle, two table
## headers, and footnotes to the table body.
  data(tbl_1)
  data(tbl_2)
  data(tbl_3)
  ## convert tbl_2 to the table body. Add a table column header to table body.
  t2 <- tbl_2 \%>\%
    rtf_colheader(colheader = "Pairwise Comparison |
                   Difference in LS Mean(95\% CI)\\\\dagger | p-Value",
                  text_justification = c("l","c","c")) \%>\%
    rtf_body(col_rel_width = c(8,7,5),
             text_justification = c("l","c","c"),
             last_row = FALSE);

  # concatenate a list of table and save to an RTF file
  t2 \%>\% rtf_encode() \%>\% write_rtf(file.path(tempdir(), "table2.rtf"))

}
